#!/usr/bin/perl -w

#
# sample_data_yaml_is_yaml.pl
# $Id$
#
# Copyright (C) 2017 University of Southern California.
# All rights reserved.                                            
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2, as published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#


=head1 NAME

sample_data_yaml_is_yaml.pl - make sure our sample data YAML output is YAML

=head1 SYNOPSIS

sample_data_yaml_is_yaml.pl [files...]

=head1 DESCRIPTION

By default, tests F<sample_data/*.yaml.trial>.

=head1 OPTIONS

=over

=item B<-d>

Enable debugging output.

=item B<-v>

Enable verbose output.

=item B<--help>

Show help.

=item B<--man>

Show full manual.

=back

=cut

use strict;
use Pod::Usage;
use Getopt::Long;
use Test::More;
use Test::YAML::Valid;

Getopt::Long::Configure ("bundling");
pod2usage(2) if ($#ARGV >= 0 && $ARGV[0] eq '-?');
#my(@orig_argv) = @ARGV;
my($prog) = $0;
my $debug = undef;
my $verbose = undef;
&GetOptions(
 	'help|?' => sub { pod2usage(1); },
	'man' => sub { pod2usage(-verbose => 2); },
	'd|debug+' => \$debug,   
        'v|verbose+' => \$verbose) or pod2usage(2);
# pod2usage("$prog: no args allowed.\n") if ($#ARGV != -1);


my @files;
if ($#ARGV == -1) {
    die "I don't see sample_data\n" if (! -d "sample_data");
    @files = glob 'sample_data/*.yaml.trial';
} else {
    @files = @ARGV;
};

plan tests => ($#files + 1);

foreach (@files) {
    yaml_file_ok($_, "$_ is valid yaml");
};
exit 0;
