use ExtUtils::MakeMaker;

WriteMakefile(
    NAME            => 'dnsanon_rssac',
    AUTHOR          => 'John Heidemann <johnh@isi.edu>',
    # xxx: this is the master version number
    VERSION         => '1.28',
    EXE_FILES => [qw(message_to_rssacint rssacfin_to_rssacyaml rssacint_reduce dsc_to_rssacint)],
    PL_FILES => {},
    PREREQ_PM => {
        'Pod::Usage' => 0,
	'Getopt::Long' => 0,
	'DateTime' => 0,
	'DateTime::Format::ISO8601' => 0,
	'Net::IP' => 0,
	'Test::More' => 0,
	'XML::Simple' => 0,
    },
    TEST_REQUIRES => {
	'Test::Pod::Coverage' => 0,
	'Test::Pod' => 0,
	'Test::YAML::Valid' => 0,
    },
);

open(MF, ">>Makefile") or die "$0: cannot append to Makefile.\n";

print MF <<'END';

README: README.md
	pandoc  -t plain -o README README.md 

README.html: README.md
	pandoc -o README.html README.md 

all:: README README.html

test::
	cd sample_data; make test

my_test:
	./TEST/rssacint_rangelist_test.pl
	cd sample_data; make test
	./TEST/sample_data_yaml_is_yaml.pl

## test:: my_test
## my_test is hooked in through test.pl

RPM_ARCH=noarch
TAR_PREFIX=dnsanon_rssac
RPM_PREFIX=perl-dnsanon_rssac
SPEC_PREFIX=$(RPM_PREFIX)
RPM_DIST=$(shell rpm --eval '%{dist}')

# the whole changelog nonesense is for the benefit of rpmlint
$(SPEC_PREFIX).spec: Makefile.PL
	cp $(SPEC_PREFIX).spec $(SPEC_PREFIX).spec~ && \
	sed -e "s/^Version: .*$$/Version: $(VERSION)/" -e '/^%changelog/,$$d' <$(SPEC_PREFIX).spec >$(SPEC_PREFIX).spec+ && \
	{ echo "%changelog"; echo '* '`date +'%a %b %d %Y'`' John Heidemann <johnh@isi.edu> '$(VERSION)-1; echo '- See https://ant.isi.edu/software/dnsanon_rssac/'; } >>$(SPEC_PREFIX).spec+ && \
	mv $(SPEC_PREFIX).spec+ $(SPEC_PREFIX).spec


rpms: $(SPEC_PREFIX).spec
	cp $(TAR_PREFIX)-$(VERSION).tar.gz $$HOME/rpmbuild/SOURCES
	cp $(SPEC_PREFIX).spec $$HOME/rpmbuild/SPECS
	( cd $$HOME/rpmbuild; rpmbuild -ba SPECS/$(SPEC_PREFIX).spec; )
	cp $$HOME/rpmbuild/RPMS/$(RPM_ARCH)/$(RPM_PREFIX)-$(VERSION)-1$(RPM_DIST).$(RPM_ARCH).rpm .
	cp $$HOME/rpmbuild/SRPMS/$(RPM_PREFIX)-$(VERSION)-1$(RPM_DIST).src.rpm .

signrpms: 
	rpmsign --addsign $(RPM_PREFIX)-$(VERSION)*.rpm

INTERNAL_WEBSITE=/home/johnh/WORKING/ANT/WWW/ant_2015/software/dnsanon_rssac
release: README.html
	@echo "You should have done; \"make manifest; make dist; make rpms; make rpmlint\""
	-make signrpms
	cp $(RPM_PREFIX)-$(VERSION)-1$(RPM_DIST).$(RPM_ARCH).rpm $(INTERNAL_WEBSITE)
	cp $(RPM_PREFIX)-$(VERSION)-1$(RPM_DIST).src.rpm $(INTERNAL_WEBSITE)
	cp $(TAR_PREFIX)-$(VERSION).tar.gz $(INTERNAL_WEBSITE)
	cp README.html $(INTERNAL_WEBSITE)/README.html
	cd $(INTERNAL_WEBSITE); git add $(RPM_PREFIX)-$(VERSION)*.rpm $(TAR_PREFIX)-$(VERSION).tar.gz README.html
	@echo "to finish: git commit -am $(VERSION)-release; git tag -s -u 0x4c6cd6f2 -m $(VERSION)-release dnsanon_rssac-$(VERSION); cd $(INTERNAL_WEBSITE); git commit -am \"release $(RPM_PREFIX)-$(VERSION)\""

rpmlint:
	rpmlint $(RPM_PREFIX)-$(VERSION)-1$(RPM_DIST).noarch.rpm
	rpmlint $(RPM_PREFIX)-$(VERSION)-1$(RPM_DIST).src.rpm

END

close MF;
